'/***
'*direct.h - function declarations for directory handling/creation
'*
'*       Copyright (c) 1985-1997, Microsoft Corporation. All rights reserved.
'*
'*Purpose:
'*       This include file contains the function declarations for the library
'*       functions related to directory handling and creation.
'*
'*       [Public]
'*
'****/

#If Not %Def(%DIRECT_INC)
    %DIRECT_INC = 1

'#pragma pack(push,8)

'typedef unsigned short wchar_t;
'typedef unsigned int size_t;

'/* _getdiskfree structure for _getdiskfree() */
#If Not %Def(%DISKFREE_T_DEFINED)
%DISKFREE_T_DEFINED = 1
Type diskfree_t
   total_clusters      As Dword
   avail_clusters      As Dword
   sectors_per_cluster As Dword
   bytes_per_sector    As Dword
End Type
#EndIf

'/* function prototypes */

'_CRTIMP int __cdecl _chdir(const char *);
Declare Function chdir_ CDecl Lib "msvcrt.dll" Alias "_chdir" ( _
   ByRef Asciiz _                           ' const char *dirname
   ) As Long                                ' int

'_CRTIMP char * __cdecl _getcwd(char *, int);
Declare Function getcwd_ CDecl Lib "msvcrt.dll" Alias "_getcwd" ( _
   ByRef Asciiz, _                          ' const char *dirname
   ByVal Long _                             ' int maxlen
   ) As Dword                               ' char *

'_CRTIMP int __cdecl _mkdir(const char *);
Declare Function mkdir_ CDecl Lib "msvcrt.dll" Alias "_mkdir" ( _
   ByRef Asciiz _                           ' const char *dirname
   ) As Long                                ' int

'_CRTIMP int __cdecl _rmdir(const char *);
Declare Function rmdir_ CDecl Lib "msvcrt.dll" Alias "_rmdir" ( _
   ByRef Asciiz _                           ' const char *dirname
   ) As Long                                ' int

'_CRTIMP int __cdecl _chdrive(int);
Declare Function chdrive_ CDecl Lib "msvcrt.dll" Alias "_chdrive" ( _
   ByVal Long _                             ' int drive
   ) As Long                                ' int

'_CRTIMP char * __cdecl _getdcwd(int, char *, int);
Declare Function getdcwd_ CDecl Lib "msvcrt.dll" Alias "_getdcwd" ( _
   ByVal Long, _                            ' int drive
   ByRef Asciiz, _                          ' char *buffer
   ByVal Long _                             ' int maxlen
   ) As Dword                               ' char *

'_CRTIMP int __cdecl _getdrive(void);
Declare Function getdrive_ CDecl Lib "msvcrt.dll" Alias "_getdrive" ( _
   ) As Long                                ' int

'_CRTIMP unsigned long __cdecl _getdrives(void);
Declare Function getdrives_ CDecl Lib "msvcrt.dll" Alias "_getdrives" ( _
   ) As Dword                               ' unsigned long

'_CRTIMP unsigned __cdecl _getdiskfree(unsigned, struct _diskfree_t *);
Declare Function getdiskfree_ CDecl Lib "msvcrt.dll" Alias "_getdiskfree" ( _
   ByVal Dword, _                           ' unsigned drive
   ByRef diskfree_t _                       ' struct _diskfree_t *driveinfo
   ) As Dword                               ' unsigned

#If Not %Def(%WDIRECT_DEFINED)
%WDIRECT_DEFINED = 1

'/* wide function prototypes, also declared in wchar.h  */

'_CRTIMP int __cdecl _wchdir(const wchar_t *);
Declare Function wchdir_ CDecl Lib "msvcrt.dll" Alias "_wchdir" ( _
   ByVal Dword _                            ' const wchar_t *dirname
   ) As Long                                ' int

'_CRTIMP wchar_t * __cdecl _wgetcwd(wchar_t *, int);
Declare Function wgetcwd_ CDecl Lib "msvcrt.dll" Alias "_wgetcwd" ( _
   ByVal Dword, _                           ' const wchar_t *dirname
   ByVal Long _                             ' int maxlen
   ) As Dword                               ' wchar_t *

'_CRTIMP wchar_t * __cdecl _wgetdcwd(int, wchar_t *, int);
Declare Function wgetdcwd_ CDecl Lib "msvcrt.dll" Alias "_wgetdcwd" ( _
   ByVal Long, _                            ' int drive
   ByRef Any, _                             ' wchar_t *buffer
   ByVal Long _                             ' int maxlen
   ) As Dword                               ' char *

'_CRTIMP int __cdecl _wmkdir(const wchar_t *);
Declare Function wmkdir_ CDecl Lib "msvcrt.dll" Alias "_wmkdir" ( _
   ByVal Dword _                            ' const wchar_t *dirname
   ) As Long                                ' int

'_CRTIMP int __cdecl _wrmdir(const wchar_t *);
Declare Function wrmdir_ CDecl Lib "msvcrt.dll" Alias "_wrmdir" ( _
   ByVal Dword _                            ' const wchar_t *dirname
   ) As Long                                ' int

#EndIf   ' #IF NOT %DEF(%WDIRECT_DEFINED)


'#pragma pack(pop)

#EndIf   ' #IF NOT %DEF(%DIRECT_INC)